/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.bonus.dto;

import java.util.Date;

import jp.mosp.common.common.BaseDto;

public class PhIndividualDto extends BaseDto {

	private static final long serialVersionUID = -4805898982549159384L;
	
	// tB[h
	private String kCode             = "";	// ЈR[h
	private Date   expectedDate          ;	// Kp\
	private Date   appliedDate           ;	// Kp
	private String businessType      = "";	// Ƌ敪
	private String calendarType      = "";	// J_[敪
	private String effortType        = "";	// ʗ敪
	private int    grade             = 0 ;	// 
	private int    notch             = 0 ;	// 
	private int    basicSalary       = 0 ;	// {
	private int    abilityAllowance  = 0 ;	// E\蓖
	private int    abilityAllowance2 = 0 ;	// E\蓖2
	private String paymentType       = "";	// x敪
	private String overtimeType      = "";	// cƋ敪
	private String paidHolidayType   = "";	// L敪
	private Date   paidHolidayMonth      ;	// LxɋNZ

	/**
	 * RXgN^
	 */
	public PhIndividualDto(){
		super();
	}
	
	// ANZT\bh
	public String getKCode            () { return kCode                         ; }	// ЈR[h
	public Date   getExpectedDate     () { return getDateField(expectedDate)    ; }	// Kp\
	public Date   getAppliedDate      () { return getDateField(appliedDate)     ; }	// Kp
	public String getBusinessType     () { return businessType                  ; }	// Ƌ敪
	public String getCalendarType     () { return calendarType                  ; }	// J_[敪
	public String getEffortType       () { return effortType                    ; }	// ʗ敪
	public int    getGrade            () { return grade                         ; }	// 
	public int    getNotch            () { return notch                         ; }	// 
	public int    getBasicSalary      () { return basicSalary                   ; }	// {
	public int    getAbilityAllowance () { return abilityAllowance              ; }	// E\蓖
	public int    getAbilityAllowance2() { return abilityAllowance2             ; }	// E\蓖2
	public String getPaymentType      () { return paymentType                   ; }	// x敪
	public String getOvertimeType     () { return overtimeType                  ; }	// cƋ敪
	public String getPaidHolidayType  () { return paidHolidayType               ; }	// L敪
	public Date   getPaidHolidayMonth () { return getDateField(paidHolidayMonth); }	// LxɋNZ
	
	public void setKCode            (String kCode            ) { this.kCode             = kCode                         ; }	// ЈR[h
	public void setExpectedDate     (Date   expectedDate     ) { this.expectedDate      = getDateField(expectedDate)    ; }	// Kp\
	public void setAppliedDate      (Date   appliedDate      ) { this.appliedDate       = getDateField(appliedDate)     ; }	// Kp
	public void setBusinessType     (String businessType     ) { this.businessType      = businessType                  ; }	// Ƌ敪
	public void setCalendarType     (String calendarType     ) { this.calendarType      = calendarType                  ; }	// J_[敪
	public void setEffortType       (String effortType       ) { this.effortType        = effortType                    ; }	// ʗ敪
	public void setGrade            (int    grade            ) { this.grade             = grade                         ; }	// 
	public void setNotch            (int    notch            ) { this.notch             = notch                         ; }	// 
	public void setBasicSalary      (int    basicSalary      ) { this.basicSalary       = basicSalary                   ; }	// {
	public void setAbilityAllowance (int    abilityAllowance ) { this.abilityAllowance  = abilityAllowance              ; }	// E\蓖
	public void setAbilityAllowance2(int    abilityAllowance2) { this.abilityAllowance2 = abilityAllowance2             ; }	// E\蓖2
	public void setPaymentType      (String paymentType      ) { this.paymentType       = paymentType                   ; }	// x敪
	public void setOvertimeType     (String overtimeType     ) { this.overtimeType      = overtimeType                  ; }	// cƋ敪
	public void setPaidHolidayType  (String paidHolidayType  ) { this.paidHolidayType   = paidHolidayType               ; }	// L敪
	public void setPaidHolidayMonth (Date   paidHolidayMonth ) { this.paidHolidayMonth  = getDateField(paidHolidayMonth); }	// LxɋNZ
	
}
